function [Ymatrix,ylabel,classes] = vet_matrix(yvector,cls)
% Routine to transform a feature vector into a matrix of
% characteristics
%
%   input
%   yvector : y vector with the feature to be transformed.
%       If: yvector is a string, the ylabel output will be a numeric vector.
%       if: yvector is a matrix, output Ymatrix will be a vector and ylabel will be a string array.
%   output:
%   Ymatrix : matrix with classes. Each column of the Ymatrix refers to one of the classes.
%   ylabel : array of classes transformed into a string.
%   classes : identification of the yvector input classes.


if isvector(yvector) && isnumeric(yvector)
        [Ymatrix,ylabel,classes] = vet_matrix_vetor(yvector,cls);  % vector
    elseif isvector(yvector) && ~isnumeric(yvector)
        [Ymatrix,ylabel,classes] = vet_matrix_string(yvector); % string
    elseif ~isvector(yvector) && isnumeric(yvector)
        [Ymatrix,ylabel,classes] = vet_matrix_matriz(yvector); % matrix
end
    

function [Ymatrix,ylabel,classes] = vet_matrix_vetor(yvector,cls)
% yvector = vetor.
classes=cls;  % classes
Ymatrix=[];
ylabel=[];
for ki=1:length(yvector)
    for kj=1:length(classes)
        if yvector(ki)==classes(kj)
            Ymatrix=[Ymatrix;1];
        else
            Ymatrix=[Ymatrix;0];
        end
    end
    ylabel=[ylabel;num2str(yvector(ki))];
end
Ymatrix=reshape(Ymatrix,length(classes),length(yvector));
Ymatrix=Ymatrix';

function [Ymatrix,ylabel,classes] = vet_matrix_string(yvector)
% yvector = string.
classes=unique(yvector,'rows');  % classes
Ymatrix=[];
ylabel=[];
for ki=1:size(yvector,1)
    ylabel=[ylabel;str2num(yvector(ki))];
    for kj=1:size(classes,1)
        if str2num(yvector(ki))==str2num(classes(kj))
            Ymatrix=[Ymatrix;1];
        else
            Ymatrix=[Ymatrix;0];
        end
    end
end
Ymatrix=reshape(Ymatrix,length(classes),length(yvector));
Ymatrix=Ymatrix';

function [Ymatrix,ylabel,classes] = vet_matrix_matriz(yvector)
% yvector = matrix.
classes=(1:size(yvector,2))';
Ymatrix=zeros(size(yvector,1),1);  % yvetor with classes
for kj=1:length(classes)
    aa1=find(yvector(:,kj)==1);
    Ymatrix(aa1)=kj;
end

ylabel=[];   % ylabel
for ki=1:length(Ymatrix)
    ylabel=[ylabel;num2str(Ymatrix(ki))];
end

